# include target system properties
include config.mk
# include file lists
include ../gcctemplate/files.mk

include ../gcctemplate/compile.mk
include ../gcctemplate/prepare.mk

export ENGINE

LIBDIR_S = ../../lib/$(TARGETSYS)
LIBDIR = $(subst /,$(PATHSEP),$(LIBDIR_S))
LIBPATH = $(LIBDIR_S)/libdecmpa.a

SODIR_S = $(LIBDIR_S)
SODIR = $(subst /,$(PATHSEP),$(SODIR_S))
SOPATH = $(SODIR_S)/libdecmpaso.so


# define the main target
# it depends on the .o files of all source files

objects : $(OBJECTS) ;

staticlib : $(LIBPATH) ;

sharedobject : $(SOPATH) ;

$(LIBPATH) : $(OBJECTS)
	-$(MKDIR) $(LIBDIR)
	ar rs $(LIBPATH) $(OBJECTS)

$(SOPATH) : $(OBJECTS)
	-$(MKDIR) $(SODIR)
	$(CC) -shared -o $(SOPATH) $(OBJECTS)
	

# include the dependency makefiles for all source files
# they contain rules stating that the .o file depends on the corresponding .cpp file
# and all the files that are included by it (recursive)
# they also contain rules that list the same dependencies for the .d file itself,
# thus causing the .d file to be automatically remade when any of the source files
# change

# make sure that the tools and subdirs exist before doing anything
# the empty file PREPARED is created when this has been done (see below)
-include PREPARED
-include $(DEPENDS)
-include PREPARED

include ../gcctemplate/examples.mk




