/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class NTIDiscover
extends JFrame {
    private static String REVISION = "1.0";
    private TextField[] ipAddr;
    private TextField[] mask;
    private TextField[] gtwAddr;
    private Label[] devName;
    private Label[] macAddr;
    private String[] ipAddrBackup;
    private String[] maskBackup;
    private String[] gtwAddrBackup;
    private JButton[] bBlink;
    private JButton[] bSubmit;
    private JButton bSubmitAll = new JButton("Submit All");
    private JButton bClose = new JButton("Close");
    private JButton bDetect = new JButton("Detect NTI Devices");
    private JButton bRefresh = new JButton("Refresh");
    public JFrame frm = new JFrame("NTI Device Discovery");
    public static final int MAX_DEVICES = 60;
    private DatagramSocket serverSocket = null;
    DatagramPacket sendPacket;
    DatagramPacket recvPacket = null;
    public byte[] buf = new byte[256];
    int devices = 0;
    private Timer timer;
    private JProgressBar progress = new JProgressBar(0, 60);
    private Container Appcp = this.getContentPane();
    private Container cp = this.frm.getContentPane();
    private String updateMessage;
    private boolean ChangesMade = false;
    private ActionListener ButtonListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int j;
            InetAddress addr;
            JButton src = (JButton)e.getSource();
            if (src == NTIDiscover.this.bDetect || src == NTIDiscover.this.bRefresh) {
                NTIDiscover.this.frm.setVisible(false);
                NTIDiscover.this.cp.setVisible(false);
                boolean minimum = false;
                int maximum = 100;
                NTIDiscover.this.devices = 0;
                NTIDiscover.this.progress.setIndeterminate(false);
                NTIDiscover.this.progress.setValue(0);
                NTIDiscover.this.progress.setStringPainted(true);
                try {
                    NTIDiscover.this.serverSocket = new DatagramSocket(4066);
                    addr = InetAddress.getByName("255.255.255.255");
                    NTIDiscover.this.buf = "NTIWS GETINFO\r".getBytes();
                    NTIDiscover.this.sendPacket = new DatagramPacket(NTIDiscover.this.buf, NTIDiscover.this.buf.length, addr, 4067);
                    NTIDiscover.this.serverSocket.send(NTIDiscover.this.sendPacket);
                    NTIDiscover.this.serverSocket.setSoTimeout(100);
                    NTIDiscover.this.timer.start();
                }
                catch (IOException v) {
                    System.err.println("Socket error" + v);
                }
                catch (SecurityException SecurityException2) {
                    System.err.println("Security error: Please accept Security Certificate to use this application");
                    NTIDiscover.this.serverSocket.close();
                }
            } else if (src == NTIDiscover.this.bSubmitAll) {
                for (j = 0; j < NTIDiscover.this.devices; ++j) {
                    NTIDiscover.this.changeValue(NTIDiscover.this.ipAddr[j], j);
                    NTIDiscover.this.changeValue(NTIDiscover.this.mask[j], j);
                    NTIDiscover.this.changeValue(NTIDiscover.this.gtwAddr[j], j);
                }
            } else if (src == NTIDiscover.this.bClose) {
                NTIDiscover.this.frm.setVisible(false);
                NTIDiscover.this.progress.setValue(0);
                for (j = 0; j < NTIDiscover.this.devices; ++j) {
                    String message = "NTIWS LEDOFF " + NTIDiscover.this.macAddr[j].getText() + "\r";
                    try {
                        NTIDiscover.this.serverSocket = new DatagramSocket(4066);
                        addr = InetAddress.getByName("255.255.255.255");
                        NTIDiscover.this.buf = message.getBytes();
                        NTIDiscover.this.sendPacket = new DatagramPacket(NTIDiscover.this.buf, NTIDiscover.this.buf.length, addr, 4067);
                        NTIDiscover.this.serverSocket.send(NTIDiscover.this.sendPacket);
                        NTIDiscover.this.serverSocket.setSoTimeout(100);
                        continue;
                    }
                    catch (IOException v) {
                        System.err.println("Socket error" + v);
                        continue;
                    }
                    finally {
                        NTIDiscover.this.serverSocket.close();
                    }
                }
            }
            for (j = 0; j < NTIDiscover.this.devices; ++j) {
                if (src == NTIDiscover.this.bBlink[j]) {
                    String message;
                    String data = NTIDiscover.this.bBlink[j].getText();
                    if (data.compareTo("Blink LED") == 0) {
                        NTIDiscover.this.bBlink[j].setText("Blinking...");
                        NTIDiscover.this.bBlink[j].setToolTipText("Device's LEDs will stop blinking.");
                        message = "NTIWS BLINKLED " + NTIDiscover.this.macAddr[j].getText() + "\r";
                    } else {
                        NTIDiscover.this.bBlink[j].setText("Blink LED");
                        NTIDiscover.this.bBlink[j].setToolTipText("Device's LEDs will blink on and off.");
                        message = "NTIWS LEDOFF " + NTIDiscover.this.macAddr[j].getText() + "\r";
                    }
                    try {
                        NTIDiscover.this.serverSocket = new DatagramSocket(4066);
                        InetAddress addr2 = InetAddress.getByName("255.255.255.255");
                        NTIDiscover.this.buf = message.getBytes();
                        NTIDiscover.this.sendPacket = new DatagramPacket(NTIDiscover.this.buf, NTIDiscover.this.buf.length, addr2, 4067);
                        NTIDiscover.this.serverSocket.send(NTIDiscover.this.sendPacket);
                        NTIDiscover.this.serverSocket.setSoTimeout(100);
                        break;
                    }
                    catch (IOException v) {
                        System.err.println("Socket error" + v);
                        break;
                    }
                    finally {
                        NTIDiscover.this.serverSocket.close();
                    }
                }
                if (src != NTIDiscover.this.bSubmit[j]) continue;
                NTIDiscover.this.changeValue(NTIDiscover.this.ipAddr[j], j);
                NTIDiscover.this.changeValue(NTIDiscover.this.mask[j], j);
                NTIDiscover.this.changeValue(NTIDiscover.this.gtwAddr[j], j);
                break;
            }
        }
    };
    private ActionListener TextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextField src = (TextField)e.getSource();
            for (int j = 0; j < NTIDiscover.this.devices; ++j) {
                if (src == NTIDiscover.this.ipAddr[j]) {
                    NTIDiscover.this.changeValue(NTIDiscover.this.ipAddr[j], j);
                    break;
                }
                if (src == NTIDiscover.this.mask[j]) {
                    NTIDiscover.this.changeValue(NTIDiscover.this.mask[j], j);
                    break;
                }
                if (src != NTIDiscover.this.gtwAddr[j]) continue;
                NTIDiscover.this.changeValue(NTIDiscover.this.gtwAddr[j], j);
                break;
            }
        }
    };

    public static void main(String[] args) {
        new NTIDiscover();
    }

    private NTIDiscover() {
        this.Appcp.setLayout(new FlowLayout());
        this.Appcp.add(this.bDetect);
        this.addWindowListener(new WindowEventHandler());
        this.setDefaultCloseOperation(2);
        this.bDetect.addActionListener(this.ButtonListener);
        this.progress.setIndeterminate(false);
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        this.Appcp.add(this.progress);
        this.frm.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                NTIDiscover.this.frm.setVisible(false);
                for (int j = 0; j < NTIDiscover.this.devices; ++j) {
                    String message = "NTIWS LEDOFF " + NTIDiscover.this.macAddr[j].getText() + "\r";
                    NTIDiscover.this.progress.setValue(0);
                    try {
                        NTIDiscover.this.serverSocket = new DatagramSocket(4066);
                        InetAddress addr = InetAddress.getByName("255.255.255.255");
                        NTIDiscover.this.buf = message.getBytes();
                        NTIDiscover.this.sendPacket = new DatagramPacket(NTIDiscover.this.buf, NTIDiscover.this.buf.length, addr, 4067);
                        NTIDiscover.this.serverSocket.send(NTIDiscover.this.sendPacket);
                        NTIDiscover.this.serverSocket.setSoTimeout(100);
                        continue;
                    }
                    catch (IOException v) {
                        System.err.println("Socket error" + v);
                        continue;
                    }
                    finally {
                        NTIDiscover.this.serverSocket.close();
                    }
                }
            }
        });
        this.timer = new Timer(100, new ActionListener(){
            public String[] devinfo = new String[60];
            public int counter = 0;
            public int len = 0;
            public byte[] mydata;

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean i = false;
                byte[] rbuf = new byte[256];
                NTIDiscover.this.recvPacket = new DatagramPacket(rbuf, rbuf.length);
                try {
                    NTIDiscover.this.serverSocket.receive(NTIDiscover.this.recvPacket);
                    this.len = NTIDiscover.this.recvPacket.getLength();
                    if (this.len > 0) {
                        this.mydata = NTIDiscover.this.recvPacket.getData();
                        if (this.mydata[0] != 0) {
                            this.devinfo[NTIDiscover.this.devices] = new String(this.mydata);
                            System.out.println(rbuf);
                            ++NTIDiscover.this.devices;
                        }
                    }
                }
                catch (SocketTimeoutException x) {
                    System.err.println("Receive error" + x);
                }
                catch (IOException v) {
                    System.err.println("Socket cannot be opened \n" + v);
                }
                ++this.counter;
                NTIDiscover.this.progress.setValue(this.counter);
                if (this.counter > 60) {
                    NTIDiscover.this.timer.stop();
                    this.counter = 0;
                    if (NTIDiscover.this.devices > 0) {
                        char[] str = new char[64];
                        NTIDiscover.this.serverSocket.close();
                        NTIDiscover.this.cp.setVisible(false);
                        NTIDiscover.this.cp.removeAll();
                        NTIDiscover.this.cp.setLayout(new GridLayout(0, 7, 6, 6));
                        Label DeviceHeader = new Label("Device");
                        DeviceHeader.setAlignment(1);
                        DeviceHeader.setFont(new Font("Ariel", 1, 12));
                        Label MACHeader = new Label("MAC Address");
                        MACHeader.setAlignment(1);
                        MACHeader.setFont(new Font("Ariel", 1, 12));
                        Label IPHeader = new Label("IP Address");
                        IPHeader.setAlignment(1);
                        IPHeader.setFont(new Font("Ariel", 1, 12));
                        Label MaskHeader = new Label("Mask");
                        MaskHeader.setAlignment(1);
                        MaskHeader.setFont(new Font("Ariel", 1, 12));
                        Label GatewayHeader = new Label("Gateway");
                        GatewayHeader.setAlignment(1);
                        GatewayHeader.setFont(new Font("Ariel", 1, 12));
                        NTIDiscover.this.cp.add(DeviceHeader);
                        NTIDiscover.this.cp.add(MACHeader);
                        NTIDiscover.this.cp.add(IPHeader);
                        NTIDiscover.this.cp.add(MaskHeader);
                        NTIDiscover.this.cp.add(GatewayHeader);
                        NTIDiscover.this.cp.add(new Label(""));
                        NTIDiscover.this.cp.add(new Label(""));
                        NTIDiscover.access$1502(NTIDiscover.this, new Label[NTIDiscover.this.devices]);
                        NTIDiscover.access$1202(NTIDiscover.this, new Label[NTIDiscover.this.devices]);
                        NTIDiscover.access$702(NTIDiscover.this, new TextField[NTIDiscover.this.devices]);
                        NTIDiscover.access$902(NTIDiscover.this, new TextField[NTIDiscover.this.devices]);
                        NTIDiscover.access$1002(NTIDiscover.this, new TextField[NTIDiscover.this.devices]);
                        NTIDiscover.access$1302(NTIDiscover.this, new JButton[NTIDiscover.this.devices]);
                        NTIDiscover.access$1402(NTIDiscover.this, new JButton[NTIDiscover.this.devices]);
                        NTIDiscover.access$1602(NTIDiscover.this, new String[NTIDiscover.this.devices]);
                        NTIDiscover.access$1702(NTIDiscover.this, new String[NTIDiscover.this.devices]);
                        NTIDiscover.access$1802(NTIDiscover.this, new String[NTIDiscover.this.devices]);
                        String[] parsed = new String[8];
                        for (int j = 0; j < NTIDiscover.this.devices; ++j) {
                            parsed = this.devinfo[j].split(" ");
                            if (parsed[0].compareTo("NTIWS") != 0 || parsed[1].compareTo("SETINFO") != 0) continue;
                            ((NTIDiscover)NTIDiscover.this).devName[j] = new Label(parsed[2]);
                            NTIDiscover.this.devName[j].setAlignment(1);
                            NTIDiscover.this.cp.add(NTIDiscover.this.devName[j]);
                            ((NTIDiscover)NTIDiscover.this).macAddr[j] = new Label(parsed[3]);
                            NTIDiscover.this.macAddr[j].setAlignment(1);
                            NTIDiscover.this.cp.add(NTIDiscover.this.macAddr[j]);
                            ((NTIDiscover)NTIDiscover.this).ipAddr[j] = new TextField(parsed[4], 10);
                            NTIDiscover.this.ipAddr[j].addActionListener(NTIDiscover.this.TextListener);
                            ((NTIDiscover)NTIDiscover.this).ipAddrBackup[j] = parsed[4].trim();
                            NTIDiscover.this.cp.add(NTIDiscover.this.ipAddr[j]);
                            ((NTIDiscover)NTIDiscover.this).mask[j] = new TextField(parsed[5], 10);
                            NTIDiscover.this.mask[j].addActionListener(NTIDiscover.this.TextListener);
                            ((NTIDiscover)NTIDiscover.this).maskBackup[j] = parsed[5].trim();
                            NTIDiscover.this.cp.add(NTIDiscover.this.mask[j]);
                            ((NTIDiscover)NTIDiscover.this).gtwAddr[j] = new TextField(parsed[6].trim(), 10);
                            NTIDiscover.this.gtwAddr[j].addActionListener(NTIDiscover.this.TextListener);
                            ((NTIDiscover)NTIDiscover.this).gtwAddrBackup[j] = parsed[6].trim();
                            NTIDiscover.this.cp.add(NTIDiscover.this.gtwAddr[j]);
                            ((NTIDiscover)NTIDiscover.this).bSubmit[j] = new JButton("Submit");
                            NTIDiscover.this.bSubmit[j].setToolTipText("Submit Changes for this device.");
                            NTIDiscover.this.bSubmit[j].addActionListener(NTIDiscover.this.ButtonListener);
                            NTIDiscover.this.cp.add(NTIDiscover.this.bSubmit[j]);
                            ((NTIDiscover)NTIDiscover.this).bBlink[j] = new JButton("Blink LED");
                            NTIDiscover.this.bBlink[j].setToolTipText("Device's LEDs will blink on and off.");
                            NTIDiscover.this.bBlink[j].addActionListener(NTIDiscover.this.ButtonListener);
                            NTIDiscover.this.cp.add(NTIDiscover.this.bBlink[j]);
                        }
                        NTIDiscover.this.cp.add(new Label(""));
                        NTIDiscover.this.cp.add(new Label(""));
                        NTIDiscover.this.cp.add(NTIDiscover.this.bSubmitAll);
                        NTIDiscover.this.bSubmitAll.setToolTipText("Submit Changes for all devices.");
                        NTIDiscover.this.bSubmitAll.addActionListener(NTIDiscover.this.ButtonListener);
                        NTIDiscover.this.cp.add(NTIDiscover.this.bRefresh);
                        NTIDiscover.this.bRefresh.setToolTipText("Refresh list of NTI devices on your network.");
                        NTIDiscover.this.bRefresh.addActionListener(NTIDiscover.this.ButtonListener);
                        NTIDiscover.this.cp.add(NTIDiscover.this.bClose);
                        NTIDiscover.this.bClose.setToolTipText("Exit NTI Discovery Application");
                        NTIDiscover.this.bClose.addActionListener(NTIDiscover.this.ButtonListener);
                        NTIDiscover.this.frm.pack();
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        Dimension windowSize = NTIDiscover.this.frm.getSize();
                        NTIDiscover.this.frm.setLocation(Math.max(0, (screenSize.width - windowSize.width) / 2), Math.max(0, (screenSize.height - windowSize.height) / 2));
                        NTIDiscover.this.frm.setVisible(true);
                        NTIDiscover.this.cp.setVisible(true);
                    } else {
                        NTIDiscover.this.cp.setVisible(false);
                        NTIDiscover.this.serverSocket.close();
                        JOptionPane.showMessageDialog(null, "No Devices Found.");
                        NTIDiscover.this.progress.setValue(0);
                    }
                }
            }
        });
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
        this.setTitle("NTIDiscover v" + REVISION);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void changeValue(Object source, int j) {
        String message = "";
        String[] octets = new String[4];
        int m = -1;
        int type = 0;
        try {
            int i;
            block30: {
                block31: {
                    block29: {
                        block27: {
                            block28: {
                                block26: {
                                    if (source != this.ipAddr[j]) break block26;
                                    type = 1;
                                    break block27;
                                }
                                if (source != this.mask[j]) break block28;
                                type = 2;
                                break block29;
                            }
                            if (source != this.gtwAddr[j]) break block30;
                            type = 3;
                            break block31;
                        }
                        for (i = 0; i < 3; ++i) {
                            m = this.ipAddr[j].getText().indexOf(".", m + 1);
                            if (m != -1) continue;
                            throw new NumberFormatException();
                        }
                        octets = this.ipAddr[j].getText().split("\\.", 4);
                        break block30;
                    }
                    for (i = 0; i < 3; ++i) {
                        m = this.mask[j].getText().indexOf(".", m + 1);
                        if (m != -1) continue;
                        throw new NumberFormatException();
                    }
                    octets = this.mask[j].getText().split("\\.", 4);
                    break block30;
                }
                for (i = 0; i < 3; ++i) {
                    m = this.gtwAddr[j].getText().indexOf(".", m + 1);
                    if (m != -1) continue;
                    throw new NumberFormatException();
                }
                octets = this.gtwAddr[j].getText().split("\\.", 4);
            }
            int[] n = new int[4];
            for (i = 0; i < 4; ++i) {
                n[i] = Integer.parseInt(octets[i]);
                if (n[i] > 255) throw new NumberFormatException();
                if (n[i] >= 0) continue;
                throw new NumberFormatException();
            }
            switch (type) {
                case 1: {
                    this.ipAddr[j].setText(n[0] + "." + n[1] + "." + n[2] + "." + n[3]);
                    if (this.ipAddrBackup[j].compareTo(this.ipAddr[j].getText()) == 0) break;
                    message = "NTIWS SETPARAM " + this.macAddr[j].getText() + " " + "P01 " + this.ipAddr[j].getText() + "\r";
                    this.ipAddrBackup[j] = this.ipAddr[j].getText();
                    break;
                }
                case 2: {
                    this.mask[j].setText(n[0] + "." + n[1] + "." + n[2] + "." + n[3]);
                    if (this.maskBackup[j].compareTo(this.mask[j].getText()) == 0) break;
                    message = "NTIWS SETPARAM " + this.macAddr[j].getText() + " " + "P02 " + this.mask[j].getText() + "\r";
                    this.maskBackup[j] = this.mask[j].getText();
                    break;
                }
                case 3: {
                    this.gtwAddr[j].setText(n[0] + "." + n[1] + "." + n[2] + "." + n[3]);
                    if (this.gtwAddrBackup[j].compareTo(this.gtwAddr[j].getText()) == 0) break;
                    message = "NTIWS SETPARAM " + this.macAddr[j].getText() + " " + "P03 " + this.gtwAddr[j].getText() + "\r";
                    this.gtwAddrBackup[j] = this.gtwAddr[j].getText();
                    break;
                }
            }
            if (message == "") return;
            try {
                this.serverSocket = new DatagramSocket(4066);
                InetAddress addr = InetAddress.getByName("255.255.255.255");
                this.buf = message.getBytes();
                this.sendPacket = new DatagramPacket(this.buf, this.buf.length, addr, 4067);
                this.serverSocket.send(this.sendPacket);
                this.serverSocket.setSoTimeout(100);
                switch (type) {
                    case 1: {
                        JOptionPane.showMessageDialog(null, this.devName[j].getText() + "'s IP Address changed.");
                        return;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(null, this.devName[j].getText() + "'s Subnet Mask changed.");
                        return;
                    }
                    case 3: {
                        JOptionPane.showMessageDialog(null, this.devName[j].getText() + "'s Gateway Address changed.");
                        return;
                    }
                }
                return;
            }
            catch (IOException v) {
                System.err.println("Socket error" + v);
                return;
            }
            finally {
                this.serverSocket.close();
            }
        }
        catch (NumberFormatException NumberFormatException2) {
            switch (type) {
                case 1: {
                    this.ipAddr[j].setText(this.ipAddrBackup[j]);
                    JOptionPane.showMessageDialog(null, "Invalid IP Address");
                    return;
                }
                case 2: {
                    this.mask[j].setText(this.maskBackup[j]);
                    JOptionPane.showMessageDialog(null, "Invalid Subnet Mask");
                    return;
                }
                case 3: {
                    this.gtwAddr[j].setText(this.gtwAddrBackup[j]);
                    JOptionPane.showMessageDialog(null, "Invalid Gateway Address");
                    return;
                }
            }
        }
    }

    static /* synthetic */ Label[] access$1502(NTIDiscover x0, Label[] x1) {
        x0.devName = x1;
        return x1;
    }

    static /* synthetic */ Label[] access$1202(NTIDiscover x0, Label[] x1) {
        x0.macAddr = x1;
        return x1;
    }

    static /* synthetic */ TextField[] access$702(NTIDiscover x0, TextField[] x1) {
        x0.ipAddr = x1;
        return x1;
    }

    static /* synthetic */ TextField[] access$902(NTIDiscover x0, TextField[] x1) {
        x0.mask = x1;
        return x1;
    }

    static /* synthetic */ TextField[] access$1002(NTIDiscover x0, TextField[] x1) {
        x0.gtwAddr = x1;
        return x1;
    }

    static /* synthetic */ JButton[] access$1302(NTIDiscover x0, JButton[] x1) {
        x0.bBlink = x1;
        return x1;
    }

    static /* synthetic */ JButton[] access$1402(NTIDiscover x0, JButton[] x1) {
        x0.bSubmit = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1602(NTIDiscover x0, String[] x1) {
        x0.ipAddrBackup = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1702(NTIDiscover x0, String[] x1) {
        x0.maskBackup = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1802(NTIDiscover x0, String[] x1) {
        x0.gtwAddrBackup = x1;
        return x1;
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            System.exit(0);
        }
    }
}

